<?php
class WoocommerceSendMailsClass{
	private $apiURL;
	private $apiHeaders;

	public function __construct(){
		$this->apiHeaders[] = 'Accept: application/json';
		$this->apiHeaders[] = 'Content-Type: application/x-www-form-urlencoded';

		$this->apiURL = 'https://app.sendmails.io/api/v1/';
	}

	public function getSendMailsListsFunc(){
		$apiURL = $this->apiURL."lists?api_token=".get_option("_sendmails_api_key");
		return $this->curlCallFunc($apiURL, "GET", [], $this->apiHeaders);
	}

    public function pluginActiveStatusMessages(){
        if(!is_plugin_active('woocommerce/woocommerce.php')){    
            echo '<div class="updated"><p><strong>'.__('Woocommerce SendMails Require Woocommerce.', 'woocommerce-sendmails-addon').'</strong></p></div>';
        }
    }
	
	public function sendMailsAddWoocommerceSettingsTabFunc($settingsTabs){
		$settingsTabs['sendmails'] = __('SendMails.io', 'woocommerce-sendmails-addon');
		return $settingsTabs;
	}
	
	public function sendMailsAddSectionsFunc(){
		global $current_section;
		
		$adminURL = admin_url('admin.php');
		
		$sectionTabs = [
			'api_key' => __('Api Key', 'woocommerce-sendmails-addon'),
			'other_settings' => __('Other Settings', 'woocommerce-sendmails-addon')
		];
		
		$sectionHtml = '<ul class="subsubsub">';
			foreach($sectionTabs as $tabID => $sectionTab){				
				$sectionURL = add_query_arg(
					[
						'page' => 'wc-settings',
						'tab' => 'sendmails',
						'section' => $tabID,
					],
					$adminURL
				);

				$currentSection = $current_section == $tabID ? 'class="current"' : '';
				$sectionSeparator = end(array_keys($sectionTabs)) === $tabID ? '' : '|';
				
				$sectionHtml .= '<li><a href="'.$sectionURL.'" '.$currentSection.'>'.$sectionTab.'</a> '.$sectionSeparator.' </li>';
			}
		$sectionHtml .= '</ul>';
		$sectionHtml .= '<br class="clear" />';
		
		echo $sectionHtml;
	}	
	
	public function sendMailsAddTabSectionContentFunc(){
		$settingHtml = '';
		
		$sendMailsLists = [];
		$sendmailApiKey = get_option('_sendmails_api_key');
		$isActiveSendmails = get_option('_sendmails_enable');
		
		wp_enqueue_style('sendmails-admin-styles', PLUGIN_WSM_PATH.'/css/admin-styles.css');
		wp_enqueue_script('sendmails-admin-scripts', PLUGIN_WSM_PATH.'/js/admin-scripts.js');
		$getLists = $this->getSendMailsListsFunc();
		
		if(!empty($getLists)){
			foreach($getLists as $getList){
				if(
					isset($getList['uid']) &&
					isset($getList['name'])
				){
					$sendMailsLists[$getList['uid']] = $getList['name'];
				}
			}
		}
			
		$settingHtml .= '<div class="woocommerce-sendmails-admin-fields">';
		if(
			isset($_GET['section']) &&
			$_GET['section'] == "other_settings"
		){
			$checkoutPageFields = [
				'billing_first_name' => 'First Name',
				'billing_last_name' => 'Last Name',
				'billing_phone' => 'Phone',
				'billing_email' => 'Email',
				'billing_company' => 'Company',
				'billing_country' => 'Country',
				'billing_address_1' => 'Address',
				'billing_city' => 'City',
				'billing_state' => 'State',
				'billing_postcode' => 'PostCode'
			];
			
			$woocommerceHooks = [
				'_sendmails_woocommerce_new_order' => [
					'type' => 'select',
					'label' => 'Select SendMails List',
					'sectionLabel' => 'Woocommerce New Order',
					'value' => get_option('_sendmails_woocommerce_new_order'),
					'options' => $sendMailsLists
				], 
				'_sendmails_woocommerce_order_status_failed' => [
					'type' => 'select',
					'label' => 'Select SendMails List',
					'sectionLabel' => 'Woocommerce Order Status Failed',
					'value' => get_option('_sendmails_woocommerce_order_status_failed'),
					'options' => $sendMailsLists
				],
				'_sendmails_woocommerce_order_status_refunded' => [
					'type' => 'select',
					'label' => 'Select SendMails List',
					'sectionLabel' => 'Woocommerce Order Status Refunded',
					'value' => get_option('_sendmails_woocommerce_order_status_refunded'),
					'options' => $sendMailsLists
				],
				'_sendmails_woocommerce_order_status_completed' => [
					'type' => 'select',
					'label' => 'Select SendMails List',
					'sectionLabel' => 'Woocommerce Order Status Completed',
					'value' => get_option('_sendmails_woocommerce_order_status_completed'),
					'options' => $sendMailsLists
				],
				'_sendmails_woocommerce_created_customer' => [
					'type' => 'select',
					'label' => 'Select SendMails List',
					'sectionLabel' => 'Woocommerce Customer Created',
					'value' => get_option('_sendmails_woocommerce_created_customer'),
					'options' => $sendMailsLists
				]
			];

			if(!$sendmailApiKey){
				$settingHtml .= '<style>p.submit{display: none;}.error-message{display: block;width: 100%; text-align:center;}</style>';
				$settingHtml .= '<strong class="error-message">Please provide Api Key!</strong>';
			}
			else{
				$settingHtml .= '<h2>Select Woocommerce Hooks</h2>';
				$settingHtml .= '<select id="woocommerce-sendmails-sections-dropdown">';
				foreach($woocommerceHooks as $name => $woocommerceHook){
	
					$settingHtml .= '<option value="'.$name.'">'.(isset($woocommerceHook['sectionLabel']) ? $woocommerceHook['sectionLabel'] : '').'</option>';
				}
				$settingHtml .= '</select>';
	
				$settingHtml .= '<div class="woocommerce-sendmails-sections-warpper">';	
					foreach($woocommerceHooks as $name => $woocommerceHook){
						$mapFieldLabelFor = explode("_sendmails_", $name);
						$mapFieldLabelFor = isset($mapFieldLabelFor[1]) ? $mapFieldLabelFor[1] : '';
						
						$settingHtml .= '<div class="woocommerce-sendmails-section woocommerce-sendmails-section-'.$name.'">';
							$settingHtml .= '<h2>Section For ('.$mapFieldLabelFor.')</h2>';
							
							$settingHtml .= $this->renderWoocommerceTextFields(
								$name, 
								(isset($woocommerceHook['label']) ? $woocommerceHook['label'] : ''), 
								(isset($woocommerceHook['type']) ? $woocommerceHook['type'] : ''),
								(isset($woocommerceHook['value']) ? $woocommerceHook['value'] : ''),
								'',
								(isset($woocommerceHook['options']) ? $woocommerceHook['options'] : [])
							);
							
							$settingHtml .= '<h2>Select Mapping For ('.$mapFieldLabelFor.')</h2>';
							
							foreach($checkoutPageFields as $fieldName => $fieldLabel){
								$fieldValue = get_option($name.'_'.$fieldName);
									
								$settingHtml .= $this->renderWoocommerceTextFields(
									$name.'_'.$fieldName, 
									$fieldLabel, 
									'text',
									get_option($name.'_'.$fieldName)
								);					
							}
							
							$settingHtml .= '<span class="woocommerce-sendmails-space"></span>';
						$settingHtml .= '</div>';
					}
				$settingHtml .= '</div>';
			}
		}
		else{
			$apiSettings = [
				'_sendmails_enable' => [
					'type' => 'checkbox',
					'label' => 'Enable SendMails',
					'value' => $isActiveSendmails
				],
				'_sendmails_api_key' => [
					'type' => 'text',
					'label' => 'SendMails Api Key',
					'value' => $sendmailApiKey
				]
			];
			
			$settingHtml .= '<h2>SendMails Api Settings</h2>';
			
			foreach($apiSettings as $name => $apiSetting){
				if(
					$name == '_sendmails_enable' &&
					$apiSetting['value'] == 1
				){
					$apiSetting['custom_attributes'] =  [
						'checked' => $isActiveSendmails
					];
				}
				
				$settingHtml .= $this->renderWoocommerceTextFields(
					$name, 
					(isset($apiSetting['label']) ? $apiSetting['label'] : ''), 
					(isset($apiSetting['type']) ? $apiSetting['type'] : ''),
					(isset($apiSetting['value']) ? $apiSetting['value'] : ''),
					(isset($apiSetting['custom_attributes']) ? $apiSetting['custom_attributes'] : '')
				);
			}
		}
		$settingHtml .= '</div>';
		
		echo $settingHtml;
	}
	
	public function sendMailsSaveTabSectionContentFunc(){
		if(
			isset($_REQUEST['tab']) &&			
			$_REQUEST['tab'] == 'sendmails'			
		){
			$sendmailsSettings = [];
			
			if(
				isset($_REQUEST['section']) &&
				$_REQUEST['section'] == 'other_settings'
			){
				unset($_REQUEST['page']);
				unset($_REQUEST['tab']);
				unset($_REQUEST['section']);
				unset($_REQUEST['save']);
				unset($_REQUEST['_wpnonce']);
				unset($_REQUEST['_wp_http_referer']);

				$sendmailsSettings = $_REQUEST;				
			}
			else if(
				!isset($_REQUEST['section']) ||
				(
					isset($_REQUEST['section']) &&
					$_REQUEST['section'] == 'api_key'
				)
			){
								
				$sendmailsSettings = [
					'_sendmails_enable' => (isset($_REQUEST['_sendmails_enable']) ? 1 : 0),
					'_sendmails_api_key' => (isset($_REQUEST['_sendmails_api_key']) ? $_REQUEST['_sendmails_api_key'] : "")
				];
			}
		}
		
		if(!empty($sendmailsSettings)){
			foreach($sendmailsSettings as $name => $value){
				update_option($name, $value);				
			}	
		}
	}
	
	private function renderWoocommerceTextFields($name, $label, $type="text", $value="", $customAttributes="", $options=[], $additionalClass=""){	
		ob_start();
			echo '<div class="'.$additionalClass.'">';
				if($type == "select"){
					woocommerce_wp_select(		
						[
							'id' => $name,
							'label' => __($label, 'woocommerce-sendmails-addon'),
							'type' => $type,
							'class' => 'short',
							'placeholder' => '',
							'desc_tip' => 'true',
							'description' => __('Enter your '.strtolower($label).' here.', 'woocommerce-sendmails-addon'),
							'value' => $value,
							'custom_attributes' => $customAttributes,
							'options' => $options
						]
					);					
				}
				else{					
					woocommerce_wp_text_input(		
						[
							'id' => $name,
							'label' => __($label, 'woocommerce-sendmails-addon'),
							'type' => $type,
							'class' => 'short',
							'placeholder' => '',
							'desc_tip' => 'true',
							'description' => __('Enter your '.strtolower($label).' here.', 'woocommerce-sendmails-addon'),
							'value' => $value,
							'custom_attributes' => $customAttributes,
							'options' => $options
						]
					);
				}
			echo '</div>';		
		$contents = ob_get_contents();
		ob_get_clean();	
		
		return $contents;
	}
	
	public function sendMailsWoocommerceOrderPlacementFunc($orderID){
		$this->sendMailsWoocommerceSendDataToListByHookTypeFunc($orderID, 'woocommerce_new_order');
	}
	
	public function sendMailsWoocommerceOrderStatusFailedFunc($orderID){
		$this->sendMailsWoocommerceSendDataToListByHookTypeFunc($orderID, 'woocommerce_order_status_failed');
	}	
	
	public function sendMailsWoocommerceOrderStatusRefundedFunc($orderID){
		$this->sendMailsWoocommerceSendDataToListByHookTypeFunc($orderID, 'woocommerce_order_status_refunded');
	}	
	
	public function sendMailsWoocommerceOrderStatusCompletedFunc($orderID){
		$this->sendMailsWoocommerceSendDataToListByHookTypeFunc($orderID, 'woocommerce_order_status_completed');
	}
	
	public function sendMailsWoocommerceCustomerCreatedFunc($customerID, $customerData, $passwordGenerated){
		$isActiveSendmails = $this->getSendMailsActiveStatus();
		
		if($isActiveSendmails){
			$postFields = "api_token=".get_option("_sendmails_api_key")."&list_uid=".$hookSettings['list_id'];
			
			if(isset($customerData['first_name'])) $postFields .= "&FIRST_NAME=".urlencode($customerData['first_name']);
			if(isset($customerData['last_name'])) $postFields .= "&LAST_NAME=".urlencode($customerData['last_name']);
			if(isset($customerData['user_email'])) $postFields .= "&EMAIL=".urlencode($customerData['user_email']);
			if(isset($_POST['billing_company'])) $postFields .= "&COMPANY=".urlencode($_POST['billing_company']);
			if(isset($_POST['billing_address_1'])) $postFields .= "&ADDRESS=".urlencode($_POST['billing_address_1']);
			if(isset($_POST['billing_city'])) $postFields .= "&CITY=".urlencode($_POST['billing_city']);
			if(isset($_POST['billing_state'])) $postFields .= "&STATE=".urlencode($_POST['billing_state']);
			if(isset($_POST['shipping_country'])) $postFields .= "&COUNTRY=".urlencode($_POST['shipping_country']);
			if(isset($_POST['billing_postcode'])) $postFields .= "&POSTCODE=".urlencode($_POST['billing_postcode']);
			if(isset($_POST['billing_phone'])) $postFields .= "&PHONE=".urlencode($_POST['billing_phone']);
			
			$this->curlCallFunc($this->apiURL."subscribers", "POST", $postFields, $this->apiHeaders);
		}
	}
	
	private function sendMailsWoocommerceSendDataToListByHookTypeFunc($orderID, $hook){
		if(
			$orderID &&
			$hook
		){
			$isActiveSendmails = $this->getSendMailsActiveStatus();
			
			if($isActiveSendmails){
				$hookSettings = $this->getSendMailsWoocommerceHooksSettingsFunc($hook);	
				
				$postFields = $this->getSendMailsFormatedPostFields($hookSettings, $orderID);
				$this->curlCallFunc($this->apiURL."subscribers", "POST", $postFields, $this->apiHeaders);
			}			
		}
	}
	
	public function getSendMailsWoocommerceHooksSettingsFunc($hook){
		$settings = [];
		
		if($hook){
			global	$wpdb;
			
			$settingsData = $wpdb->get_results('SELECT option_name, option_value FROM '.$wpdb->options.' WHERE option_name LIKE "_sendmails_'.$hook.'%"');
			
			if(!empty($settingsData)){
				foreach($settingsData as $settingData){
					if(isset($settingData->option_name)){
						if($settingData->option_name == '_sendmails_'.$hook) $settings['list_id'] = (isset($settingData->option_value) ? $settingData->option_value : '');
						else{
							$optionName = str_replace('_sendmails_'.$hook.'_', '', $settingData->option_name);
							
							$settings[$optionName] = (isset($settingData->option_value) ? $settingData->option_value : '');
						}
					}
				}
			}
		}
		
		return $settings;
	}
	
	public function getSendMailsFormatedPostFields($hookSettings, $orderID){
		$postFields = "";

		if(
			isset($hookSettings['list_id']) &&
			!empty($hookSettings['list_id'])
		){	
		/*$addressOne = get_post_meta($orderID, '_billing_address_1', true);
			$addressTwo = get_post_meta($orderID, '_billing_address_2', true);
			$addressCity = get_post_meta($orderID, '_billing_city', true);
			$state = get_post_meta($orderID, '_billing_state', true);
			$postCode = get_post_meta($orderID, '_billing_postcode', true);
			$country = get_post_meta($orderID, '_billing_country', true);
			
			$address = ($addressOne ? $addressOne : '');
			if($address && $addressTwo) $address .= ', '.$addressTwo;
			if($address && $addressCity) $address .= ', '.$addressCity;
			if($address && $state) $address .= ', '.$state;
			if($address && $postCode) $address .= ', '.$postCode;
			if($address && $country) $address .= ', '.$country;
			
			$company = get_post_meta($orderID, '_billing_company', true); */
		
			$postFields = "api_token=".get_option("_sendmails_api_key")."&list_uid=".$hookSettings['list_id'];
			
			foreach($hookSettings as $settingID => $settingData){
				if($settingID != 'list_id'){
					$value = get_post_meta($orderID, '_'.$settingID, true);
						
					if(
						!empty($value) &&
						!empty($settingData)
					){
						$postFields .= "&".$settingData."=".urlencode($value);
					}
				}
			}
		}		
		
		return $postFields;
	}
	
	private function getSendMailsActiveStatus(){
		$isActiveSendmails = get_option('_sendmails_enable');		
		$sendmailApiKey = get_option('_sendmails_api_key');
		
		return ($isActiveSendmails && $sendmailApiKey) ? 1 : 0;
	}
	
	/* CURL REQUESTS */
	private function curlCallFunc($url, $requestType, $fields, $headers){	
		$curl = curl_init();

		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_ENCODING, "");
		curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $requestType);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
		
		if(
			$requestType == "POST" ||
			$requestType == "PATCH"
		){
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_POSTFIELDS, $fields);	
		}
		else if(!empty($fields)){
			curl_setopt($curl, CURLOPT_POSTFIELDS, $fields);	
		}

		$response = curl_exec($curl);
		$error = curl_error($curl);
		
		curl_close($curl);
		$response = str_replace("^", "", $response);
		$response = ($error) ? "cURL Error #:".$error : (($this->isJson($response)) ? json_decode($response, true) : $response);
		
		return $response;
	}

	private function isJson($string) {
		json_decode($string);
		return json_last_error() === JSON_ERROR_NONE;
	}	
}